OUTPUT_FORMAT("elf32-littlearm", "elf32-bigarm", "elf32-littlearm")
OUTPUT_ARCH(arm)
ENTRY(_start)
OUTPUT(rom.elf)

MEMORY {
    /*
     * general memory
     * NOTE: use iwram for fast ('critical') arm code, use ewram for
     *       slow thumb code
     */
    /* system ROM: 32-bit bus, c: 1/1/1 */
    bios  ( X): ORIGIN = 0x00000000, LENGTH = 0x00004000 /* 16k */
    /* on-board RAM: 16-bit bus, c: 3/3/6 */
    ewram (WX): ORIGIN = 0x02000000, LENGTH = 0x00040000 /* 256k */
    /* internal RAM: 32-bit bus, c: 1/1/1 */
    iwram (WX): ORIGIN = 0x03000000, LENGTH = 0x00008000 /* 32k */
    /* IO registers: 32-bit bus, c: 1/1/1 */
    ioreg (W ): ORIGIN = 0x04000000, LENGTH = 0x00000400 /* 1k */

    /*
     * display memory
     * NOTE: these regions do *NOT* accept 8-bit writes, doing so will
     *       fuck up everything!
     * NOTE: add one to the cycle count if the video hw accesses it at
     *       the same time
     */
    /* palette RAM: 16-bit bus, c: 1/1/2 */
    pram (W): ORIGIN = 0x05000000, LENGTH = 0x00001000 /* 4k */
    /* video RAM: 16-bit bus, c: 1/1/2 */
    vram (W): ORIGIN = 0x06000000, LENGTH = 0x00018000 /* 96k */
    /* OBJ attrs: 32-bit bus, c: 1/1/1 */
    oam  (W): ORIGIN = 0x07000000, LENGTH = 0x00000400 /* 1k */

    /*
     * external memory (game pak)
     * NOTE: cycle cout is a minimum, it depends on the waitstate
     *       settings
     */
    /* flashROM waitstate 0: 16-bit bus, c: 5/5/8 */
    romws0 (X): ORIGIN = 0x08000000, LENGTH = 0x02000000 /* 32M */
    /* flashROM waitstate 1: 16-bit bus, c: 5/5/8 */
    romws1 (X): ORIGIN = 0x0A000000, LENGTH = 0x02000000
    /* flashROM waitstate 2: 16-bit bus, c: 5/5/8 */
    romws2 (X): ORIGIN = 0x0C000000, LENGTH = 0x02000000
    /* savedata: 8-bit bus, c: 5/-/- */
    sram   (W): ORIGIN = 0x0E000000, LENGTH = 0x00010000 /* 64k */
}

__heap_end    = ORIGIN(ewram) + LENGTH(ewram);
__iwram_end   = ORIGIN(iwram) + LENGTH(iwram);
__sp_irq      = __iwram_end - 0x060;
__sp_sys      = __sp_irq    - 0x0a0;

__min_stack_size = 0x00100;
__min_heap_size  = 0x10000;

/* section defs for IO regs etc. */
SECTIONS {
    . = ORIGIN(bios);
    .bios ALIGN(4) (NOLOAD) :
    {
        . = ORIGIN(bios);
        *(.bios*)
    } >bios

    . = ORIGIN(pram);
    .pram ALIGN(2) (NOLOAD) :
    {
        . = ORIGIN(pram);
        *(.pram*)
    } >pram
    . = ORIGIN(vram);
    .vram ALIGN(2) (NOLOAD) :
    {
        . = ORIGIN(vram);
        *(.vram*)
    } >vram
    . = ORIGIN(oam);
    .oam ALIGN(4) (NOLOAD) :
    {
        . = ORIGIN(oam);
        *(.oam*)
    } >oam

    . = ORIGIN(sram);
    .sram ALIGN(1) (NOLOAD) :
    {
        . = ORIGIN(sram);
        *(.sram*)
    } >sram

    /*/DISCARD/ :
    {
        *(.glue* .vfp11_veneer .v4_bx .iplt .rel.dyn .igot.plt .rel.iplt)
        *(.comment .ARM.attributes .debug*)
    }*/
}

